function listTriplets(obj,motifNum,N,threshold)
%LISTTRIPLETS List specific triplet motifs, weighted by strength

polyads = loadPolyads('polyads.txt');
[Aorig labels] = getSquareMatrix(obj);
A = Aorig>=threshold;
% clear self loops
A(logical(eye(size(A)))) = 0;


% Use Chklovskii method to find the actual triplets
D = (1-A).*(1-A)'; D = D - D.*eye(size(D)); % not Aij and not Aji
U = A.*(1-A)';  %Aij and not Aji
B = A.*A'; % Aij and Aji

% Number of motifs to display
if nargin<3,N = 5; end;

switch motifNum
    case 10
        motif10
    case 11
        motif11
    case 12
        motif12
    case 14
        motif14
        
end

    function motif10
        M = U.*(U^2);  % = sum(diag(U^2*U'));
        cases = zeros(sum(sum(M)),4);
        casesIdx = 1;
        [i j] = find(M);
        disp('Feed forward motif');
        
        for kk = 1:numel(i)
            % find the intermediate path for this motif
            subCases = U(i(kk),:) & U(:,j(kk))';
            idcs = find(subCases);
            for jj = 1:sum(subCases)
                cases(casesIdx,:) = [i(kk) idcs(jj) j(kk) rnk([Aorig(i(kk),idcs(jj)) Aorig(idcs(jj),j(kk)) Aorig(i(kk),j(kk))])];
                casesIdx = casesIdx + 1;
            end
        end
        
        [vals sortedIdxs] = sort(cases(:,4),'descend');
        clear vals;
        for kk = 1:N
            currCase = cases(sortedIdxs(kk),:);
            fprintf('Geometric mean: %f\n',currCase(4));
            fprintf('%s to %s\t%u\n',labels{[currCase(1:2)]},Aorig(currCase(1),currCase(2)));
            fprintf('%s to %s\t%u\n',labels{[currCase(2:3)]},Aorig(currCase(2),currCase(3)));
            fprintf('%s to %s\t%u\n',labels{[currCase(1) currCase(3)]},Aorig(currCase(1),currCase(3)));
            s = matchPolyad(labels{currCase(1)},labels(currCase([2,3])));
            if s>0
                fprintf('Strength of dyad at %s: %u\n',labels{currCase(1)},s);
            end
            
            fprintf('\n');
        end
    end
    function motif11
        M = U'.* (U^2);
        cases = zeros(sum(sum(M)),4);
        casesIdx = 1;
        [i j] = find(M);
        disp('Cycle motif');
        
        for kk = 1:numel(i)
            % find the intermediate path for this motif
            subCases = U(i(kk),:) & U(:,j(kk))';
            idcs = find(subCases);
            for jj = 1:sum(subCases)
                cases(casesIdx,:) = [i(kk) idcs(jj) j(kk) rnk([Aorig(i(kk),idcs(jj)) Aorig(idcs(jj),j(kk)) Aorig(j(kk),i(kk))])];
                casesIdx = casesIdx + 1;
            end
        end
        
        % Need to skip motifs so as to not report things 3 times
        [vals sortedIdxs] = sort(cases(:,4),'descend');
        clear vals;
        for kk = 1:3:(N*3)
            currCase = cases(sortedIdxs(kk),:);
            fprintf('Rank: %f\n',currCase(4));
            fprintf('%s to %s\t%u\n',labels{[currCase(1:2)]},Aorig(currCase(1),currCase(2)));
            fprintf('%s to %s\t%u\n',labels{[currCase(2:3)]},Aorig(currCase(2),currCase(3)));
            fprintf('%s to %s\t%u\n',labels{[currCase(3) currCase(1)]},Aorig(currCase(3),currCase(1)));
            fprintf('\n');
        end
        
        
    end

    function motif12
        M = B .* (U' * U);
        cases = zeros(sum(sum(M)),4);
        casesIdx = 1;
        [i j] = find(M);
        disp('Symmetric feed-forward motif');
        for kk = 1:numel(i)
            Utrans = U';
            subCases = Utrans(i(kk),:) & U(:,j(kk))';
            idcs = find(subCases);
            for jj = 1:sum(subCases)
                cases(casesIdx,:) = [i(kk) idcs(jj) j(kk) rnk([Aorig(idcs(jj),i(kk)) Aorig(idcs(jj),j(kk)) Aorig(j(kk),i(kk)) Aorig(i(kk),j(kk))])];
                casesIdx = casesIdx + 1;
            end
        end
        
        [vals sortedIdxs] = sort(cases(:,4),'descend');
        clear vals;
        for kk = 1:2:(N*2)
            currCase = cases(sortedIdxs(kk),:);
            fprintf('Rank: %f\n',currCase(4));
            fprintf('%s to %s\t%u\n',labels{[currCase([2,1])]},Aorig(currCase(2),currCase(1)));
            fprintf('%s to %s\t%u\n',labels{[currCase(2:3)]},Aorig(currCase(2),currCase(3)));
            fprintf('%s to %s\t%u\n',labels{[currCase(1) currCase(3)]},Aorig(currCase(1),currCase(3)));
            fprintf('%s to %s\t%u\n',labels{[currCase(3) currCase(1)]},Aorig(currCase(3),currCase(1)));
            s = matchPolyad(labels{currCase(2)},labels(currCase([1,3])));
            if s>0
                fprintf('Strength of dyad at %s: %u\n',labels{currCase(2)},s);
            end
            fprintf('\n');
        end
        
    end
    function motif14
        M = B.*(U*U');
        cases = zeros(sum(sum(M)),4);
        casesIdx = 1;
        [i j] = find(M);
        disp('Symmetric dual potentiation motif');
        for kk = 1:numel(i)
            Utrans = U';
            subCases = U(i(kk),:) & Utrans(:,j(kk))';
            idcs = find(subCases);
            for jj = 1:sum(subCases)
                cases(casesIdx,:) = [i(kk) idcs(jj) j(kk) rnk([Aorig(i(kk),idcs(jj)) Aorig(j(kk),idcs(jj)) Aorig(j(kk),i(kk)) Aorig(i(kk),j(kk))])];
                casesIdx = casesIdx + 1;
            end
        end
        
        [vals sortedIdxs] = sort(cases(:,4),'descend');
        clear vals;
        for kk = 1:2:(N*2)
            currCase = cases(sortedIdxs(kk),:);
            fprintf('Rank: %f\n',currCase(4));
            fprintf('%s to %s\t%u\n',labels{currCase([1,2])},Aorig(currCase(1),currCase(2)));
            fprintf('%s to %s\t%u\n',labels{currCase([3,2])},Aorig(currCase(3),currCase(2)));
            fprintf('%s to %s\t%u\n',labels{[currCase(1) currCase(3)]},Aorig(currCase(1),currCase(3)));
            fprintf('%s to %s\t%u\n',labels{[currCase(3) currCase(1)]},Aorig(currCase(3),currCase(1)));
%             s = matchPolyad(labels{currCase(2)},labels(currCase([1,3])));
%             if s>0
%                 fprintf('Strength of dyad at %s: %u\n',labels{currCase(2)},s);
%             end
            fprintf('\n');
        end
    end

    function r = rnk(X)
        r = geomean(X);
    end

    function stren = matchPolyad(pre,post)
        idces = strcmp(pre,{polyads.pre});
        idces = find(idces);
        for idx = idces
            if isempty(setdiff(polyads(idx).post,post))
                
                stren = polyads(idx).strength;
                return;
            end
        end
        stren = 0;
    end




% tripletcount(11) = 1/3*sum(sum(U'.*(U^2)));
% tripletcount(12) = 1/2*sum(sum(B.*(U'*U)));
% tripletcount(13) = sum(sum(B.*(U^2)));
% tripletcount(14) = 1/2*sum(sum(B.*(U*U')));
% tripletcount(15) = sum(sum(U.*(B^2)));
% tripletcount(16) = 1/6*sum(sum(B.*(B^2)));

end

